"use client"

import ProductCard from "./product-card"
import PromoBanner from "./promo-banner"
import { getBestSales, getComputers, getPhones, getSpeakers } from "@/lib/features/web/service"
import { useQuery } from "@tanstack/react-query"
import { ProductProps } from "@/lib/features/web/type"
import { url } from "@/lib/constant"
import Loading from "../loading"
import PromoSingleBanner from "./promo-single-banner"
import PromoThirdBanner from "./promo-third-banner"
import Categories from "./navbar"
import Header from "./header"
import Footer from "./footer"


export default function ProductList() {

    //phones
    const { data, isLoading, error } = useQuery({
        queryKey: ["phones"],
        queryFn: () => getPhones(),
    });

    //best sales

    const { data: bestSalesData, isLoading: isBestLoading, error: errorBest } = useQuery({
        queryKey: ["best-sales"],
        queryFn: () => getBestSales(),
    });


    //computers

    const { data: computerData, isLoading: isComputerLoading, error: errorComputer } = useQuery({
        queryKey: ["computers"],
        queryFn: () => getComputers(),
    });


    //speakers

    const { data: speakerData, isLoading: isSpeakerLoading, error: errorSpeaker } = useQuery({
        queryKey: ["speakers"],
        queryFn: () => getSpeakers(),
    });


    if (isLoading || isBestLoading  || isComputerLoading || isSpeakerLoading) {
        return <Loading />;
    }

    if (error) return "Network error ";
    if (errorBest) return "Network error ";

    if (errorComputer) return "Network error ";
    if (errorSpeaker) return "Network error ";

    const phones: ProductProps[] = data?.data || [];

    const sales: ProductProps[] = bestSalesData?.data || [];

    const computers: ProductProps[] = computerData?.data || [];

    const speakers: ProductProps[] = speakerData?.data || [];


  return (
    <main className="min-h-screen">

      {/* Header */}
      <Header />
      

      {/* Navigation */}
      <Categories />



      {/* Promo Banner */}
      <PromoBanner />

      {/* Products Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
            Phones deals
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {phones?.map( (phoneItem) =>(

                <ProductCard 
                    image={url+'img/'+phoneItem?.tbl_productPhoto}
                    title={phoneItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(phoneItem?.tbl_productPrice) )}
                    
                    token={phoneItem?.tbl_productToken}
                    key={phoneItem?.tbl_productToken}
                />
            ))}

          </div>
        </div>
      </section>

      <br />


      {/* Promo Banner */}
      <PromoSingleBanner url="banner2.avif" />



      {/* Products Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Best sales
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {sales?.map( (saleItem) =>(

                <ProductCard 
                    image={url+'img/'+saleItem?.tbl_productPhoto}
                    title={saleItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(saleItem?.tbl_productPrice) )}
                    
                      token={saleItem?.tbl_productToken}

                      key={saleItem?.tbl_productToken}
                />
            ))}

          </div>
        </div>
      </section>

      <br />

      {/* Promo Banner */}
      <PromoThirdBanner url="banner3.avif" />


      {/* Products Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Laptops & accessories
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {computers?.map( (computerItem) =>(

                <ProductCard 
                    image={url+'img/'+computerItem?.tbl_productPhoto}
                    title={computerItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(computerItem?.tbl_productPrice) )}

                    token={computerItem?.tbl_productToken}
                    key={computerItem?.tbl_productToken}
                />
            ))}

          </div>
        </div>
      </section>

      <br />



      {/* Products Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Speakers
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {speakers?.map( (speakerItem) =>(

                <ProductCard 
                    image={url+'img/'+speakerItem?.tbl_productPhoto}
                    title={speakerItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(speakerItem?.tbl_productPrice) )}

                  token={speakerItem?.tbl_productToken}
                  key={speakerItem?.tbl_productToken}

                />
            ))}

          </div>
        </div>
      </section>

      <br />


      {/* WhatsApp Chat Button */}
      <Footer />

    </main>
  )
}
