import type { Metadata } from "next";
import localFont from "next/font/local";
import "./globals.css";
import "./css/style.css";
import TanstackProvider from "@/providers/TanstackProvider";
import { Toaster } from "sonner";

const geistSans = localFont({
  src: "./fonts/GeistVF.woff",
  variable: "--font-geist-sans",
  weight: "100 900",
});
const geistMono = localFont({
  src: "./fonts/GeistMonoVF.woff",
  variable: "--font-geist-mono",
  weight: "100 900",
});

export const metadata: Metadata = {
  title: "Kigaliphoneskt",
  description: "",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased`}
      >
        <main className="flex grainy-light flex-col min-h-[calc(100vh-3.5rem-1px)]" >
          <div className='flex-1 flex flex-col h-full'>

            <TanstackProvider>
              {children}
              <Toaster position="bottom-right" richColors />

            </TanstackProvider>
          </div>
        </main>
      </body>
    </html>
  );
}
