/* eslint-disable @typescript-eslint/no-explicit-any */
"use serve"
import axiosInstance from "@/lib/constant";
//import { AxiosResponse } from "axios";

export const getPhones=()=> {
   return axiosInstance.get(`product/phones`);
}


export const getBestSales=()=> {
  return axiosInstance.get(`product/best-sales`);
}


export const getComputers=()=> {
  return axiosInstance.get(`product/computers`);
}


export const getSpeakers=()=> {
  return axiosInstance.get(`product/speakers`);
}
 

export const getOneProduct=(prodId: string)=> {
  return axiosInstance.get(`product/view?tk=${prodId}`);
}
 

export const getproductForcategory=(categoryId: string)=> {
  return axiosInstance.get(`product/category?c=${categoryId}`);
}


export const getOneCategory=(categoryId: string)=> {
  return axiosInstance.get(`product/category-details?c=${categoryId}`);
}


export const getCategories=()=> {
  return axiosInstance.get(`product/categories`);
}

export const getImages=(prodId: string)=> {
  return axiosInstance.get(`product/images?tk=${prodId}`);
}


export const getColors=(prodId: string)=> {
  return axiosInstance.get(`product/colors?tk=${prodId}`);
}


export const getFeatures=(prodId: string)=> {
  return axiosInstance.get(`product/features?tk=${prodId}`);
}

export const getPrices=(prodId: string)=> {
  return axiosInstance.get(`product/prices?tk=${prodId}`);
}


