"use client";

import { OrderProps, ProductProps } from "@/lib/features/web/type";
import { Label } from "@/components/ui/label";
import { Input } from "@/components/ui/input";
import { useState } from "react";
import { useMutation, useQueryClient } from "@tanstack/react-query";
import { buyNow } from "@/lib/features/web/service";
import { toast } from "sonner";
import PayNow from "./pay-form";
import Modal from "@/components/modal";
import { LoaderCircle } from "lucide-react";

interface Props {
  details: ProductProps;
  sizeId: string;
  qty: number;
  price: number;
}

export default function BuyNow({ details, sizeId, qty, price }: Props) {

    const [name, setName] = useState('');
    const [email, setEmail] = useState('');

    const [phone, setPhone] = useState('');
    const [address, setAddress] = useState('');

    const [isLoading, setIsLoading] = useState(false);
    const [isCreated, setIsCreated] = useState(false);

    //modal state
    const[order, setOrder] = useState<OrderProps>();
    
    const [showModal, setShowModal] = useState(false);
    const openModal = () => {
        setShowModal(true);
    }
  
    const queryClient = useQueryClient();
    //buy now
    
  const mutation = useMutation({
    mutationFn: buyNow,
    onSuccess: (data) => {

      setIsLoading(false);
      setIsCreated(true);

      const res = data?.data as unknown as OrderProps;
    //   console.log(res);
    //   return false;

      queryClient.invalidateQueries({ queryKey: ["createOrder"] });
      toast.info("Order created successfully");

      if(res?.tbl_orderId){
        setOrder(res);
        openModal();
      }

      //window.location.reload();
    },
    onError: (
      //error: any
    ) => {

        setIsLoading(false);
        alert('Order creation failed');

        return false;
      //console.error(error);
      //toast.error("An error has occurred: " + error.message);
      //window.location.reload();
    },
  });

  function onSubmit() {

    if(name === null || name === ''){

    }else {

      setIsLoading(true);

      const body = {
        name,
        email,
        phone,
        address,
        prodId: Number(details?.tbl_productId),
        sizeId: Number(sizeId),
        qty
      };

      mutation.mutate(body);
    }


  }

  return (
    <>
      <Modal isOpen={showModal} onClose={() => setShowModal(false)}>
        {order && <PayNow orderDetails={order} />}
      </Modal>

    <div className="w-full max-w-xl mx-auto bg-white shadow-md rounded-2xl p-3 sm:p-4 md:p-5">
      <h4 className="text-center text-gray-800 mb-6">
        Buy 
        <b>{" "+details?.tbl_productBrand}</b>
      </h4>

      <form className="space-y-5">
        <div>
          <Label htmlFor="name" className="block text-sm font-medium text-gray-700 mb-1">
            Full name
          </Label>
          <Input
            disabled={isCreated}
            value={name}
            onChange={(e) => setName(e.target.value)}
            className="h-11 px-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"
          />
        </div>

        {/* Email */}
        <div>
          <Label htmlFor="email" className="block text-sm font-medium text-gray-700 mb-1">
            Email Address
          </Label>
          <Input
            disabled={isCreated}
            value={email}
            onChange={(e)=>setEmail(e.target.value)}
            type="email"
            className="h-11 px-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"
          />
        </div>

        {/* Phone */}
        <div>
          <Label htmlFor="phone" className="block text-sm font-medium text-gray-700 mb-1">
            Phone
          </Label>
          <Input
            disabled={isCreated}
            value={phone}
            onChange={(e)=> setPhone(e.target.value)}
            type="tel"
            className="h-11 px-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"
          />
        </div>

        {/* Shipping address */}
        <div>
          <Label htmlFor="company" className="block text-sm font-medium text-gray-700 mb-1">
            Shipping address
          </Label>
          <Input
            disabled={isCreated}
            value={address}
            onChange={(e) => setAddress(e.target.value)}
            className="h-11 px-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"
          />
        </div>

        {/* Submit Button */}

        <>
        {isCreated === false ? 
        <div className="pt-2">
          <button onClick={() => onSubmit()}
            style={{
              backgroundImage: "linear-gradient(179deg, rgb(10, 112, 227) 0.46%, rgb(3, 78, 162) 87.03%)"
            }}
            type="button"
            className="w-full hover:bg-blue-700 text-white font-medium py-3 rounded-lg transition duration-200"
          >  
            {isLoading ? 
                <LoaderCircle className="animate-spin w-4 h-4" /> 
              : 
                "Buy Now ( RWF "+new Intl.NumberFormat().format(Number(price))+" )"
            }
          </button>
        </div>
        : ""}
        </>
      </form>
    </div>
    </>
  );
}
