import Flag from "@/img/flag.png"
import Link from "next/link";

import Image from "next/image"
import { Search, ShoppingCart, Phone} from "lucide-react"

export default function Header() {



  return (
    <>
      <header className="text-white" 
        style={{
          backgroundImage: "linear-gradient(179deg, rgb(10, 112, 227) 0.46%, rgb(3, 78, 162) 87.03%)"
        }}
      >
        <div className="container-fluid mx-auto px-4 py-3">
          <div className="flex flex-col md:flex-row items-center justify-between gap-4">
            <div className="flex items-center gap-2">
              <Link href="/" className="text-2xl font-bold text-white">
                Kigaliphoneskt
              </Link>
              <Image
                src={Flag}
                alt="Rwanda Flag"
                width={56}
                height={44}
                className="ml-2"
              />
              <span className="hidden md:inline-block ml-4">Deliver to Rwanda</span>
            </div>

            <div className="flex-1 max-w-xl">
              <div className="relative">
                <input
                  type="text"
                  placeholder="Search products..."
                  className="w-full py-2 px-4 rounded-md text-black"
                />
                <button className="absolute right-0 top-0 h-full bg-blue-500 px-4 rounded-r-md">
                  <Search className="text-white" />
                </button>
              </div>
            </div>

            <div className="flex items-center gap-4">
              <Link href="#" className="flex items-center gap-1">
                <ShoppingCart />
                <span>Cart(0)</span>
              </Link>
              <Link href="#" className="flex items-center gap-1">
                <span>Orders</span>
              </Link>
              <Link href="https://wa.me/250788889611" className="flex items-center gap-1">
                <Phone />
                <span>0788 889 611</span>
              </Link>
            </div>
          </div>
        </div>

      </header>

      {/*<div className="grid grid-cols-1 sm:grid-cols-1 md:grid-cols-1 lg:grid-cols-1 xl:grid-cols-1 gap-6 mt-900">
          <Image
            src={Banner}
            alt="Brand"
            width={500}
            height={300}
            className="w-full"
          />
        </div>*/}

        </>

  )

}
      