import { getCategories } from "@/lib/features/web/service";
import { CategoryProps } from "@/lib/features/web/type";
import { useQuery } from "@tanstack/react-query";
import Link from "next/link";

export default function Categories() {


    // categories
    const { data, isLoading, error } = useQuery({
      queryKey: ["categories"],
      queryFn: () => getCategories(),
    });


    if (isLoading ) {
        return 
    }

    if (error) return "Network error ";

    const categories: CategoryProps[] = data?.data || [];


  return (
      
      
      
      <nav className="bg-white border-b shadow-sm">
        <div className="container-fluid mx-auto overflow-x-auto">
          <ul className="flex whitespace-nowrap py-3 px-4">
            <li className="mr-6" style={{fontSize: 14}}>
              <Link href="/" className="hover:text-cyan-500">
                Home
              </Link>
            </li>

            <>
                {categories?.map( (categ) => (

                    <li className="mr-6" style={{fontSize: 13}} key={categ?.tbl_product_categToken} >
                        <Link href={"/category/"+categ?.tbl_product_categToken} className="hover:text-cyan-500">
                            {categ?.tbl_product_categName?.toUpperCase()}
                        </Link>
                    </li>
                ))}

            </>


          </ul>
        </div>
      </nav>

  )

}