"use client";

import { OrderProps } from "@/lib/features/web/type";

interface Props {
  orderDetails: OrderProps;
}

export default function PayNow({ orderDetails}: Props) {

    

  return (
    <div className="w-full max-w-xl mx-auto bg-white shadow-md rounded-2xl p-3 sm:p-4 md:p-5">
      <h4 className="text-center text-gray-800 mb-6">
        Pay
        <b>{" " + orderDetails?.tbl_productBrand}</b>
      </h4>

      <form
        className="space-y-5"
        action="https://www.afripay.africa/checkout/index.php"
        method="post"
        id="afripayform"
      >
        <input type="hidden" name="amount" value={orderDetails?.tbl_orderAmt} />
        <input type="hidden" name="currency" value="RWF" />
        <input type="hidden" name="comment" value="Order 122" />
        <input
          type="hidden"
          name="client_token"
          value={orderDetails?.tbl_orderTransId}
        />
        <input
          type="hidden"
          name="return_url"
          value="https://kigaliphoneskt.com"
        />
        <input
          type="hidden"
          name="app_id"
          value="8ccdb52c8cb762d0015abafa93dd5242"
        />
        <input type="hidden" name="app_secret" value="JDJ5JDEwJDBYY1B6" />
        <p>
          <input
            style={{
              backgroundImage:
                "linear-gradient(179deg, rgb(10, 112, 227) 0.46%, rgb(3, 78, 162) 87.03%)",
            }}
            className="w-full hover:bg-blue-700 text-white font-medium py-3 rounded-lg transition duration-200"
            type="submit"
            value="Pay with MOMO / Bank"
            alt="Paywith AfriPay"
            //onClick="document.afripayform.submit();"
          />
        </p>
      </form>
    </div>
  );
}
