import Image from "next/image"
import Link from "next/link"

interface ProductCardProps {
  image: string
  title: string
  color: string
  price: string,
  token: string
}

export default function ProductCard({ image, title, color, price, token }: ProductCardProps) {
  return (
    <Link href={`/view/${token}`}>
      <div className="bg-white rounded-lg overflow-hidden shadow-md hover:shadow-lg transition-shadow">
        <div className="p-4">
          <div className="aspect-square relative mb-3">
            <Image src={image || "/placeholder.svg"} alt={`${title} ${color}`} fill className="object-contain" />
          </div>
          <div className="text-center">
            <h3 style={{height: 50, overflow: 'hidden'}} className="font-medium text-gray-800">{title}</h3>
            <p className="font-bold mt-2">RWF {price}</p>
          </div>
        </div>
      </div>
    </Link>
  )
}
