"use client"

import ProductCard from "./product-card"
import PromoBanner from "./promo-banner"
import { getAds, getBestSales, getComputers, getPhones, getSpeakers, getWatches } from "@/lib/features/web/service"
import { useQuery } from "@tanstack/react-query"
import { AdProps, ProductProps } from "@/lib/features/web/type"
import { imageurl } from "@/lib/constant"
import Loading from "../loading"
import PromoSingleBanner from "./promo-single-banner"
import PromoThirdBanner from "./promo-third-banner"
import Categories from "./navbar"
import Header from "./header"
import Footer from "./footer"
import MomopayBanner from "./momopay"


export default function ProductList() {

    //phones
    const { data, isLoading, error } = useQuery({
        queryKey: ["phones"],
        queryFn: () => getPhones(),
    });

    //best sales

    const { data: bestSalesData, isLoading: isBestLoading, error: errorBest } = useQuery({
        queryKey: ["best-sales"],
        queryFn: () => getBestSales(),
    });


    //computers

    const { data: computerData, isLoading: isComputerLoading, error: errorComputer } = useQuery({
        queryKey: ["computers"],
        queryFn: () => getComputers(),
    });


    //speakers

    const { data: speakerData, isLoading: isSpeakerLoading, error: errorSpeaker } = useQuery({
        queryKey: ["speakers"],
        queryFn: () => getSpeakers(),
    });


    //watches
    const { data: watchData, isLoading: isWatchLoading, error: errorWatch } = useQuery({
        queryKey: ["watches"],
        queryFn: () => getWatches(),
    });

    //images
    const { data: imageData, isLoading: isImageLoading, error: errorImage } = useQuery({
      queryKey: ["images"],
      queryFn: () => getAds("01", 5),
    });


    // if (isLoading || isBestLoading  || isComputerLoading || isSpeakerLoading || isWatchLoading) {
    //     return <Loading />;
    // }

    if (isLoading) {
        return <Loading />;
    }

    if (error) return "Network error ";
    if (errorBest) return "Network error ";

    if (errorComputer) return "Network error ";
    if (errorSpeaker) return "Network error ";

    if (errorWatch) return "Network error ";
    if (errorImage) return "Network error ";

    const phones: ProductProps[] = data?.data || [];

    const sales: ProductProps[] = bestSalesData?.data || [];

    const computers: ProductProps[] = computerData?.data || [];

    const speakers: ProductProps[] = speakerData?.data || [];

    const watches: ProductProps[] = watchData?.data || [];

    const ads: AdProps[] = imageData?.data || [];

    


  return (
    <main className="min-h-screen">

      {/* Header */}
      <Header />
      

      {/* Navigation */}
      <Categories />

      {/************* MOmo Banner */}
      <MomopayBanner />



      {/* Promo Banner */}
      <PromoBanner ads={isImageLoading || !ads[0] ? [] : ads} />

      {/* Phones Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
            Phones deals
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {isLoading  ? <Loading /> :phones?.map( (phoneItem) =>(

                <ProductCard 
                    image={imageurl+'img/'+phoneItem?.tbl_productPhoto}
                    title={phoneItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(phoneItem?.tbl_productPrice) )}
                    
                    token={phoneItem?.tbl_productToken}
                    key={phoneItem?.tbl_productToken}
                />
            ))}

          </div>
        </div>
      </section>

      <br />


      {/* Promo Banner */}
      <PromoSingleBanner url="banner2.avif" />



      {/* Best sales Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Best sales
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {isBestLoading  ? <Loading /> : sales?.map( (saleItem) =>(

                <ProductCard 
                    image={imageurl+'img/'+saleItem?.tbl_productPhoto}
                    title={saleItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(saleItem?.tbl_productPrice) )}
                    
                      token={saleItem?.tbl_productToken}

                      key={saleItem?.tbl_productToken}
                />
            ))}

          </div>
        </div>
      </section>

      <br />

      {/* Promo Banner */}
      <PromoThirdBanner url="banner3.avif" />


      {/* Computers Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Laptops & accessories
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {isComputerLoading  ? <Loading /> :computers?.map( (computerItem) =>(

                <ProductCard 
                    image={imageurl+'img/'+computerItem?.tbl_productPhoto}
                    title={computerItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(computerItem?.tbl_productPrice) )}

                    token={computerItem?.tbl_productToken}
                    key={computerItem?.tbl_productToken}
                />
            ))}

          </div>
        </div>
      </section>

      <br />



      {/* Speakers Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Speakers
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {isSpeakerLoading  ? <Loading /> :speakers?.map( (speakerItem) =>(

                <ProductCard 
                    image={imageurl+'img/'+speakerItem?.tbl_productPhoto}
                    title={speakerItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(speakerItem?.tbl_productPrice) )}

                  token={speakerItem?.tbl_productToken}
                  key={speakerItem?.tbl_productToken}

                />
            ))}

          </div>
        </div>
      </section>

      <br />


      {/* Watches Section */}
      <section className="py-12 bg-gray-100">
        <div className="container-fluid mx-auto px-4">
          <h2 className="text-3xl font-bold text-center mb-10 flex items-center justify-center">
            <span className="border-t border-gray-400 w-16 mr-4"></span>
              Watches
            <span className="border-t border-gray-400 w-16 ml-4"></span>
          </h2>

          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6">
            {isWatchLoading  ? <Loading /> :watches?.map( (watchItem) =>(

                <ProductCard 
                    image={imageurl+'img/'+watchItem?.tbl_productPhoto}
                    title={watchItem?.tbl_productBrand}
                    color="Gold"
                    price={new Intl.NumberFormat("en-US", {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2,
                      }).format( Number(watchItem?.tbl_productPrice) )}

                  token={watchItem?.tbl_productToken}
                  key={watchItem?.tbl_productToken}

                />
            ))}

          </div>
        </div>
      </section>

      <br />


      {/* WhatsApp Chat Button */}
      <Footer />

    </main>
  )
}
