"use client"
import Image from "next/image"
import Slider from "react-slick"

import { AdProps } from "@/lib/features/web/type"
import { imageurl } from "@/lib/constant"

interface Props {
  ads: AdProps[];
}
export default function PromoBanner({ ads }: Props) {

  if (!ads || ads.length === 0) return null;


  const settings = {
    dots: true,
    infinite: true,
    speed: 500,
    slidesToShow: 1,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    arrows: true,
  }

  return (
    <div className="w-full overflow-hidden px-0 py-1">

    <div className="grid grid-cols-1 md:grid-cols-12 gap-4">

      <div className="col-span-12 md:col-span-12">
        <Slider {...settings}>
          
          {ads?.map((adItem: AdProps) =>(
            <div className="relative w-full h-64 md:h-64 sm:h-8" key={adItem?.tbl_adToken}>
              <center>
                <Image
                  src={imageurl+'img/'+adItem?.tbl_adPhoto}
                  alt="Promo slide 1"
                  fill
                  className="object-cover"
                />
              </center>
            </div>

          ))}

        
        </Slider>
      </div>

    </div>
    </div>
  )
}
